function [fun_1,fun_2,fun_3] = fault_slip_integrand(a,alpha,b,ddelta_dy_cross,delta,...
    delta_c,dy_cross,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,g,...
    G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi,...
    y_cross,y_int,y_delta,y_minus,y_plus)
%
% Function values for evaluation of integral and conditions 1 and 2.
%
[~,~,~,sigma_C,~,~,~,~,~,~,~,~,~,~,~,~,~,~] = ...
    fault_slip_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_reg,g,...
    kappa,K_eff,mu_dyn,mu_st,1,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,...
    xi,xi);    

if flag_coupled == 0 || flag_merged == 1 
    fun_1 = -sigma_C       ./   sqrt((y_plus-xi).*(xi-y_minus));
    fun_2 = -sigma_C .* xi ./   sqrt((y_plus-xi).*(xi-y_minus));
    fun_3 = -sigma_C       ./ ( sqrt((y_plus-xi).*(xi-y_minus)) .* (y_int'-xi) );
else
    [sigma_shear_cross,~] = ...
        fault_slip_sigma_breve(ddelta_dy_cross,dy_cross,G,1,nu,y_cross,xi,xi);
    
    fun_1 = -(sigma_C - sigma_shear_cross)       ./   sqrt((y_plus-xi).*(xi-y_minus));
    fun_2 = -(sigma_C - sigma_shear_cross) .* xi ./   sqrt((y_plus-xi).*(xi-y_minus));
    fun_3 = -(sigma_C - sigma_shear_cross)       ./ ( sqrt((y_plus-xi).*(xi-y_minus)) ...
        .* (y_int'-xi) );
end
